#include <genesis.h>
#include <resources.h>
#include <string.h>
#include "megapong.h"

#define SCREEN_WIDTH   320
#define SCREEN_HEIGHT  224
#define LEFT_EDGE      0
#define RIGHT_EDGE     320
#define TOP_EDGE       0
#define BOTTOM_EDGE    224
#define Chosby_base    0

// ========= GAME STATE ========= //
static bool game_on;

// Scores
static int score;
static int score2;
static char str_score[4];
static char str_score2[4];
static char label_score[9]  = "P1 SCORE";
static char label_score2[9] = "P2 SCORE";
static char msg_start[22]   = "PRESS START TO BEGIN!";
static char msg_reset[37]   = "GAME OVER! PRESS START TO PLAY AGAIN.";

// Sprites
static Sprite* ball;
static Sprite* player;
static Sprite* player2;

// Ball physics
static int ball_pos_x, ball_pos_y;
static int ball_vel_x, ball_vel_y;
static int ball_width  = 32;
static int ball_height = 32;

// Player 1 paddle
static int player_pos_x, player_pos_y;
static int player_vel_y;
static int player_width  = 8;
static int player_height = 32;

// Player 2 paddle
static int player2_pos_x, player2_pos_y;
static int player2_vel_y;
static int player2_width  = 8;
static int player2_height = 32;

// Scrolling text
static char scroll_text[] = "                HAPPY BIRTHDAY EIKON!                ";
static int scroll_offset;

// ========= FUNCTION DECLARATIONS ========= //
static void updateScoreDisplay();
static void updateScoreDisplay2();
static void myJoyHandler(u16 joy, u16 changed, u16 state);
static void positionPlayer();
static void moveBall();
static void showText(char* s);
static void startGame();
static void endGame();
static void scrollText();

// ========================================= //
//          UTILITY
// ========================================= //
static int sign(int x) { return (x > 0) - (x < 0); }

// ========================================= //
//         START OF GAME MODULE
// ========================================= //
void runMegapong()
{
    // Reset game state
    game_on = FALSE;
    score = 0;
    score2 = 0;
    scroll_offset = 0;

    // Reset screen — safe for sub-game.
    VDP_resetScreen();

    // Draw HUD text
    VDP_setTextPlane(BG_A);
    VDP_drawText(label_score, 1, 1);
    VDP_drawText(label_score2, 28, 1);
    VDP_drawText("CHOSPONG", 17, 1);
    updateScoreDisplay();
    updateScoreDisplay2();
    showText(msg_start);

    // Background tiles
    VDP_loadTileSet(bgtile.tileset, 1, DMA);
    VDP_fillTileMapRect(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), 0, 0, 40, 30);
    PAL_setPalette(PAL1, bgtile.palette->data, DMA);
    PAL_setPalette(PAL2, chosby.palette->data, DMA);

    // Sprites
    SPR_init();

    // Initial positions
    ball_pos_x = 150;
    ball_pos_y = 80;
    ball_vel_x = 1;
    ball_vel_y = 1;

    player_pos_x = 288;
    player_pos_y = 96;
    player_vel_y = 0;

    player2_pos_x = 32;
    player2_pos_y = 96;
    player2_vel_y = 0;

    // Create sprites
    ball    = SPR_addSprite(&chosby,  ball_pos_x,  ball_pos_y,  TILE_ATTR(PAL2,0,FALSE,FALSE));
    player  = SPR_addSprite(&vpaddle, player_pos_x, player_pos_y, TILE_ATTR(PAL1,0,FALSE,FALSE));
    player2 = SPR_addSprite(&vpaddle, player2_pos_x, player2_pos_y, TILE_ATTR(PAL1,0,FALSE,FALSE));

    // Controls
    JOY_setEventHandler(myJoyHandler);

    // ------------- MAIN GAME LOOP ------------- //
    while(1)
    {
        scrollText();

        if (game_on)
        {
            moveBall();
            positionPlayer();
        }

        SPR_update();
        SYS_doVBlankProcess();

        // --- EXIT BACK TO MENU (BUTTON B) ---
        if (JOY_readJoypad(JOY_1) & BUTTON_B)
            break;
    }

    // Cleanup ----------------------------------------------------
    SPR_end();          // free sprite memory
    VDP_resetScreen();  // wipe graphics
}

// ========================================= //
// IMPLEMENTATION OF ORIGINAL FUNCTIONS
// ========================================= //

static void updateScoreDisplay(){
    sprintf(str_score,"%d",score);
    VDP_clearText(1,2,3);
    VDP_drawText(str_score,1,2);
}

static void updateScoreDisplay2(){
    sprintf(str_score2,"%d", score2);
    VDP_clearText(30,2,3);
    VDP_drawText(str_score2, 30, 2);
}

static void showText(char s[]){
    VDP_drawText(s, 20 - strlen(s)/2 ,15);
}

static void endGame(){
    char final_msg[40];

    if(score > score2)
        sprintf(final_msg, "P1 WINS! FINAL SCORE: %d - %d", score, score2);
    else if(score2 > score)
        sprintf(final_msg, "P2 WINS! FINAL SCORE: %d - %d", score2, score);
    else
        sprintf(final_msg, "IT'S A TIE! FINAL SCORE: %d - %d", score, score2);

    VDP_clearTextArea(0, 10, 40, 4);
    showText(final_msg);
    VDP_drawText(msg_reset, 20 - strlen(msg_reset)/2, 17);

    game_on = FALSE;
}

static void startGame(){
    score = 0;
    score2 = 0;
    updateScoreDisplay();
    updateScoreDisplay2();

    ball_pos_x = 160;
    ball_pos_y = SCREEN_HEIGHT / 2 - ball_height / 2;
    ball_vel_x = 1;
    ball_vel_y = 1;

    VDP_clearTextArea(0,10,40,10);
    game_on = TRUE;
}

static void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)       player_vel_y = 3;
        else if (state & BUTTON_DOWN) player_vel_y = -3;
        else if (changed & (BUTTON_UP|BUTTON_DOWN))
            player_vel_y = 0;

        if (state & BUTTON_START)
            if(!game_on) startGame();
    }

    if (joy == JOY_2)
    {
        if (state & BUTTON_UP)        player2_vel_y = 3;
        else if (state & BUTTON_DOWN) player2_vel_y = -3;
        else if (changed & (BUTTON_UP|BUTTON_DOWN))
            player2_vel_y = 0;
    }
}

static void positionPlayer(){
    player_pos_y += player_vel_y;
    if(player_pos_y < TOP_EDGE) player_pos_y = TOP_EDGE;
    if(player_pos_y + player_height > BOTTOM_EDGE)
        player_pos_y = BOTTOM_EDGE - player_height;

    player2_pos_y += player2_vel_y;
    if(player2_pos_y < TOP_EDGE) player2_pos_y = TOP_EDGE;
    if(player2_pos_y + player2_height > BOTTOM_EDGE)
        player2_pos_y = BOTTOM_EDGE - player2_height;

    SPR_setPosition(player, player_pos_x, player_pos_y);
    SPR_setPosition(player2, player2_pos_x, player2_pos_y);
}

static void moveBall(){
    if(ball_pos_x < LEFT_EDGE)              endGame();
    else if(ball_pos_x + ball_width > RIGHT_EDGE) endGame();

    if(ball_pos_y < TOP_EDGE){
        ball_pos_y = TOP_EDGE;
        ball_vel_y = -ball_vel_y;
    }
    else if(ball_pos_y + ball_height > BOTTOM_EDGE){
        ball_pos_y = BOTTOM_EDGE - ball_height;
        ball_vel_y = -ball_vel_y;
    }

    // Paddle collisions
    if(ball_pos_x < player_pos_x + player_width &&
       ball_pos_x + ball_width > player_pos_x &&
       ball_pos_y < player_pos_y + player_height &&
       ball_pos_y + ball_height >= player_pos_y)
    {
        ball_pos_x = player_pos_x - ball_width + 1;
        ball_vel_x = -ball_vel_x;
        score++;
        updateScoreDisplay();

        if(score % 10 == 0){
            ball_vel_x += sign(ball_vel_x);
            ball_vel_y += sign(ball_vel_y);
        }
    }

    if(ball_pos_x < player2_pos_x + player2_width &&
       ball_pos_x + ball_width > player2_pos_x &&
       ball_pos_y < player2_pos_y + player2_height &&
       ball_pos_y + ball_height >= player2_pos_y)
    {
        ball_pos_x = player2_pos_x + player2_width;
        ball_vel_x = -ball_vel_x;

        score2++;
        updateScoreDisplay2();

        if(score2 % 10 == 0){
            ball_vel_x += sign(ball_vel_x);
            ball_vel_y += sign(ball_vel_y);
        }
    }

    ball_pos_x += ball_vel_x;
    ball_pos_y += ball_vel_y;

    SPR_setPosition(ball, ball_pos_x, ball_pos_y);
    SPR_setAnim(ball, Chosby_base);
}

static void scrollText(){
    char display_text[41];
    int len = strlen(scroll_text);

    for (int i = 0; i < 40; i++)
        display_text[i] = scroll_text[(scroll_offset + i) % len];

    display_text[40] = '\0';

    VDP_clearTextLine(30);
    VDP_drawText(display_text, 0, 25);

    static int frame_counter = 0;
    frame_counter++;
    if (frame_counter >= 5){
        scroll_offset = (scroll_offset + 1) % len;
        frame_counter = 0;
    }
}